<?php
/**
 *  PHP Mikrotik Billing (#/)
 *  by https://t.me/ibnux
 **/


class Timezone {
    public static function timezoneList()
    {
        $timezoneIdentifiers = DateTimeZone::listIdentifiers();
        $utcTime = new DateTime('now', new DateTimeZone('UTC'));

        $tempTimezones = array();
        foreach ($timezoneIdentifiers as $timezoneIdentifier) {
            $currentTimezone = new DateTimeZone($timezoneIdentifier);

            $tempTimezones[] = array(
                'offset' => (int)$currentTimezone->getOffset($utcTime),
                'identifier' => $timezoneIdentifier
            );
        }

        // Sort the array by offset,identifier ascending
        usort($tempTimezones, function($a, $b) {
            return ($a['offset'] == $b['offset'])
                ? strcmp($a['identifier'], $b['identifier'])
                : $a['offset'] - $b['offset'];
        });

        $timezoneList = array();
        foreach ($tempTimezones as $tz) {
            $sign = ($tz['offset'] > 0) ? '+' : '-';
            $offset = gmdate('H:i', abs($tz['offset']));
            $timezoneList[$tz['identifier']] = '(UTC ' . $sign . $offset . ') ' .
                $tz['identifier'];
        }

        return $timezoneList;
    }

    public static function getTimeOffset($tz = 'Asia/Jakarta'){
        $utcTime = new DateTime('now', new DateTimeZone('UTC'));
        $currentTimezone = new DateTimeZone($tz);
        $offset = $currentTimezone->getOffset($utcTime);
        $sign = ($offset > 0) ? '+' : '-';
        $offset = gmdate('H:i', abs($offset));
        return $sign.$offset;
    }
}